/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerMachineClient;

public class DockerMachineClientProviderStrategy
extends DockerClientProviderStrategy {
    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        DockerClient client;
        try {
            boolean installed = DockerMachineClient.instance().isInstalled();
            Preconditions.checkArgument(installed, "docker-machine executable was not found on PATH (" + Arrays.toString(CommandLine.getSystemPath()) + ")");
            Optional<String> machineNameOptional = DockerMachineClient.instance().getDefaultMachine();
            Preconditions.checkArgument(machineNameOptional.isPresent(), "docker-machine is installed but no default machine could be found");
            String machineName = machineNameOptional.get();
            LOGGER.info("Found docker-machine, and will use machine named {}", (Object)machineName);
            DockerMachineClient.instance().ensureMachineRunning(machineName);
            String dockerDaemonIpAddress = DockerMachineClient.instance().getDockerDaemonIpAddress(machineName);
            LOGGER.info("Docker daemon IP address for docker machine {} is {}", (Object)machineName, (Object)dockerDaemonIpAddress);
            this.config = DockerClientConfig.createDefaultConfigBuilder().withDockerHost("tcp://" + dockerDaemonIpAddress + ":2376").withDockerTlsVerify(true).withDockerCertPath(Paths.get(System.getProperty("user.home") + "/.docker/machine/certs/", new String[0]).toString()).build();
            client = this.getClientForConfig(this.config);
        }
        catch (Exception e) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException(e.getMessage());
        }
        this.ping(client, 30);
    }

    @Override
    public String getDescription() {
        return "docker-machine";
    }
}

