/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.InternetProtocol;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ExposedPort {
    private final InternetProtocol protocol;
    private final int port;

    public ExposedPort(int port, InternetProtocol protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public ExposedPort(int port) {
        this(port, InternetProtocol.DEFAULT);
    }

    @Deprecated
    public ExposedPort(String scheme, int port) {
        this(port, InternetProtocol.valueOf(scheme));
    }

    public InternetProtocol getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public String getScheme() {
        return this.protocol.toString();
    }

    public int getPort() {
        return this.port;
    }

    public static ExposedPort tcp(int port) {
        return new ExposedPort(port, InternetProtocol.TCP);
    }

    public static ExposedPort udp(int port) {
        return new ExposedPort(port, InternetProtocol.UDP);
    }

    public static ExposedPort parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split("/");
            switch (parts.length) {
                case 1: {
                    return new ExposedPort(Integer.parseInt(parts[0]));
                }
                case 2: {
                    return new ExposedPort(Integer.parseInt(parts[0]), InternetProtocol.parse(parts[1]));
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing ExposedPort '" + serialized + "'");
        }
    }

    public String toString() {
        return this.port + "/" + this.protocol.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExposedPort) {
            ExposedPort other = (ExposedPort)obj;
            return new EqualsBuilder().append((Object)this.protocol, (Object)other.getProtocol()).append(this.port, other.getPort()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.protocol).append(this.port).toHashCode();
    }

    public static class Serializer
    extends JsonSerializer<ExposedPort> {
        @Override
        public void serialize(ExposedPort exposedPort, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            jsonGen.writeFieldName(exposedPort.toString());
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<ExposedPort> {
        @Override
        public ExposedPort deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (!node.equals(NullNode.getInstance())) {
                Map.Entry<String, JsonNode> field = node.fields().next();
                return ExposedPort.parse(field.getKey());
            }
            return null;
        }
    }
}

