/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.LogMessageWaitStrategy;

public class PostgreSQLContainer<SELF extends PostgreSQLContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    static final String NAME = "postgresql";
    static final String IMAGE = "postgres";
    public static final Integer POSTGRESQL_PORT = 5432;
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";

    public PostgreSQLContainer() {
        this("postgres:latest");
    }

    public PostgreSQLContainer(String dockerImageName) {
        super(dockerImageName);
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*database system is ready to accept connections.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(POSTGRESQL_PORT);
    }

    protected void configure() {
        this.addExposedPort(POSTGRESQL_PORT);
        this.addEnv("POSTGRES_DB", this.databaseName);
        this.addEnv("POSTGRES_USER", this.username);
        this.addEnv("POSTGRES_PASSWORD", this.password);
        this.setCommand(IMAGE);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getContainerIpAddress() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/" + this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((GenericContainer)this);
    }
}

