/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;

public class PostgreSQLContainer<SELF extends PostgreSQLContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "postgresql";
    public static final String IMAGE = "postgres";
    public static final Integer POSTGRESQL_PORT = 5432;
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";

    public PostgreSQLContainer() {
        this("postgres:latest");
    }

    public PostgreSQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(POSTGRESQL_PORT);
    }

    protected void configure() {
        this.addExposedPort(POSTGRESQL_PORT);
        this.addEnv("POSTGRES_DB", this.databaseName);
        this.addEnv("POSTGRES_USER", this.username);
        this.addEnv("POSTGRES_PASSWORD", this.password);
        this.setCommand(IMAGE);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getContainerIpAddress() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/" + this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }
}

