/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;

public class PostgreSQLContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "postgresql";
    public static final String IMAGE = "postgres";
    public static final Integer POSTGRESQL_PORT = 5432;

    public PostgreSQLContainer() {
        super("postgres:latest");
    }

    public PostgreSQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(POSTGRESQL_PORT);
    }

    protected void configure() {
        this.addExposedPort(POSTGRESQL_PORT);
        this.addEnv("POSTGRES_DATABASE", "test");
        this.addEnv("POSTGRES_USER", "test");
        this.addEnv("POSTGRES_PASSWORD", "test");
        this.setCommand(IMAGE);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getIpAddress() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }
}

