/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class PostgreSQLContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "postgresql";
    public static final String IMAGE = "postgres";
    private String postgresPort;

    public PostgreSQLContainer() {
        super("postgres:latest");
    }

    public PostgreSQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected void containerIsStarting(ContainerInfo containerInfo) {
        this.postgresPort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("5432/tcp")).get(0)).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.postgresPort;
    }

    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"5432"}).env(new String[]{"POSTGRES_DATABASE=test", "POSTGRES_USER=test", "POSTGRES_PASSWORD=test"}).cmd(new String[]{IMAGE}).build();
    }

    public String getName() {
        return NAME;
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.dockerHostIpAddress + ":" + this.postgresPort + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }
}

