/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class MSSQLServerContainer<SELF extends MSSQLServerContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    static final String NAME = "mssqlserver";
    static final String IMAGE = "microsoft/mssql-server-linux";
    public static final Integer MS_SQL_SERVER_PORT = 1433;
    private String username = "SA";
    private String password = "A_Str0ng_Required_Password";

    public MSSQLServerContainer() {
        this("microsoft/mssql-server-linux:latest");
    }

    public MSSQLServerContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    protected void configure() {
        this.addExposedPort(MS_SQL_SERVER_PORT);
        this.addEnv("ACCEPT_EULA", "Y");
        this.addEnv("SA_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:sqlserver://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public Connection createConnection(String queryString) throws SQLException {
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        String url = this.getJdbcUrl() + queryString;
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        try {
            return (Connection)Unreliables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, () -> jdbcDriverInstance.connect(url, info));
        }
        catch (Exception e) {
            throw new SQLException("Could not create new connection", e);
        }
    }
}

