/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.localstack;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.rnorth.ducttape.Preconditions;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class LocalStackContainer
extends GenericContainer<LocalStackContainer> {
    public static final String VERSION = "0.10.8";
    private static final String HOSTNAME_EXTERNAL_ENV_VAR = "HOSTNAME_EXTERNAL";
    private final List<Service> services = new ArrayList<Service>();

    public LocalStackContainer() {
        this(VERSION);
    }

    public LocalStackContainer(String version) {
        super(TestcontainersConfiguration.getInstance().getLocalStackImage() + ":" + version);
        this.withFileSystemBind("//var/run/docker.sock", "/var/run/docker.sock");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
    }

    protected void configure() {
        String hostnameExternalReason;
        super.configure();
        Preconditions.check((String)"services list must not be empty", (!this.services.isEmpty() ? 1 : 0) != 0);
        this.withEnv("SERVICES", this.services.stream().map(Service::getLocalStackName).collect(Collectors.joining(",")));
        if (this.getEnvMap().containsKey(HOSTNAME_EXTERNAL_ENV_VAR)) {
            hostnameExternalReason = "explicitly as environment variable";
        } else if (this.getNetwork() != null && this.getNetworkAliases() != null && this.getNetworkAliases().size() >= 1) {
            this.withEnv(HOSTNAME_EXTERNAL_ENV_VAR, (String)this.getNetworkAliases().get(this.getNetworkAliases().size() - 1));
            hostnameExternalReason = "to match last network alias on container with non-default network";
        } else {
            this.withEnv(HOSTNAME_EXTERNAL_ENV_VAR, this.getContainerIpAddress());
            hostnameExternalReason = "to match host-routable address for container";
        }
        this.logger().info("{} environment variable set to {} ({})", new Object[]{HOSTNAME_EXTERNAL_ENV_VAR, this.getEnvMap().get(HOSTNAME_EXTERNAL_ENV_VAR), hostnameExternalReason});
        for (Service service : this.services) {
            this.addExposedPort(service.getPort());
        }
    }

    public LocalStackContainer withServices(Service ... services) {
        this.services.addAll(Arrays.asList(services));
        return (LocalStackContainer)this.self();
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(Service service) {
        return new AwsClientBuilder.EndpointConfiguration(this.getEndpointOverride(service).toString(), this.getRegion());
    }

    public URI getEndpointOverride(Service service) {
        try {
            String address;
            String ipAddress = address = this.getContainerIpAddress();
            ipAddress = InetAddress.getByName(address).getHostAddress();
            return new URI("http://" + ipAddress + ":" + this.getMappedPort(service.getPort()));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalStateException("Cannot obtain endpoint URL", e);
        }
    }

    public AWSCredentialsProvider getDefaultCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getAccessKey(), this.getSecretKey()));
    }

    public String getAccessKey() {
        return "accesskey";
    }

    public String getSecretKey() {
        return "secretkey";
    }

    public String getRegion() {
        return "us-east-1";
    }

    public static enum Service {
        API_GATEWAY("apigateway", 4567),
        KINESIS("kinesis", 4568),
        DYNAMODB("dynamodb", 4569),
        DYNAMODB_STREAMS("dynamodbstreams", 4570),
        S3("s3", 4572),
        FIREHOSE("firehose", 4573),
        LAMBDA("lambda", 4574),
        SNS("sns", 4575),
        SQS("sqs", 4576),
        REDSHIFT("redshift", 4577),
        SES("ses", 4579),
        ROUTE53("route53", 4580),
        CLOUDFORMATION("cloudformation", 4581),
        CLOUDWATCH("cloudwatch", 4582),
        SSM("ssm", 4583),
        SECRETSMANAGER("secretsmanager", 4584),
        STEPFUNCTIONS("stepfunctions", 4585),
        CLOUDWATCHLOGS("logs", 4586),
        STS("sts", 4592),
        IAM("iam", 4593);

        final String localStackName;
        final int port;

        private Service(String localStackName, int port) {
            this.localStackName = localStackName;
            this.port = port;
        }

        public String getLocalStackName() {
            return this.localStackName;
        }

        public int getPort() {
            return this.port;
        }
    }
}

