/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class PubSubEmulatorContainer
extends GenericContainer<PubSubEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/google-cloud-cli");
    private static final DockerImageName CLOUD_SDK_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/cloud-sdk");
    private static final String CMD = "gcloud beta emulators pubsub start --host-port 0.0.0.0:8085";
    private static final int PORT = 8085;

    public PubSubEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, CLOUD_SDK_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8085});
        this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx("(?s).*started.*$"));
        this.withCommand(new String[]{"/bin/sh", "-c", CMD});
    }

    public String getEmulatorEndpoint() {
        return this.getHost() + ":" + this.getMappedPort(8085);
    }
}

