/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DatastoreEmulatorContainer
extends GenericContainer<DatastoreEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/google-cloud-cli");
    private static final DockerImageName CLOUD_SDK_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/cloud-sdk");
    private static final String CMD = "gcloud beta emulators datastore start --project test-project --host-port 0.0.0.0:8081";
    private static final int HTTP_PORT = 8081;
    private String flags;

    public DatastoreEmulatorContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public DatastoreEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, CLOUD_SDK_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8081});
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/").forStatusCode(200));
    }

    protected void configure() {
        String command = CMD;
        if (this.flags != null && !this.flags.isEmpty()) {
            command = command + " " + this.flags;
        }
        this.withCommand(new String[]{"/bin/sh", "-c", command});
    }

    public DatastoreEmulatorContainer withFlags(String flags) {
        this.flags = flags;
        return this;
    }

    public String getEmulatorEndpoint() {
        return this.getHost() + ":" + this.getMappedPort(8081);
    }
}

