/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class BigtableEmulatorContainer
extends GenericContainer<BigtableEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/cloud-sdk");
    private static final String CMD = "gcloud beta emulators bigtable start --host-port 0.0.0.0:9000";
    private static final int PORT = 9000;

    public BigtableEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9000});
        this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx("(?s).*running.*$"));
        this.withCommand(new String[]{"/bin/sh", "-c", CMD});
    }

    public String getEmulatorEndpoint() {
        return this.getHost() + ":" + this.getEmulatorPort();
    }

    public int getEmulatorPort() {
        return this.getMappedPort(9000);
    }
}

