/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script.ruby;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.script.AbstractScript;
import org.tentackle.script.ScriptRuntimeException;
import org.tentackle.script.ScriptVariable;
import org.tentackle.script.ScriptingLanguage;
import org.tentackle.script.ruby.CompiledRubyScript;
import org.tentackle.script.ruby.RubyLanguage;

public class RubyScript
extends AbstractScript {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyScript.class);
    private static final Map<String, CompiledRubyScript> SCRIPT_CACHE = new ConcurrentHashMap<String, CompiledRubyScript>();
    private final ScriptingContainer container;
    private volatile CompiledRubyScript compiledScript;

    public RubyScript(RubyLanguage language, ScriptingContainer container, String code, boolean cached, boolean threadSafe) {
        super((ScriptingLanguage)language, code, cached, threadSafe);
        this.container = container;
    }

    public void validate() {
        this.getCompiledScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Set<ScriptVariable> variables) {
        T result;
        block7: {
            result = null;
            CompiledRubyScript script = this.getCompiledScript();
            if (LOGGER.isFinerLoggable()) {
                LOGGER.finer("execute: \n" + script.getCode() + "\nwith args: " + ScriptVariable.variablesToString(variables), new Object[0]);
            }
            try {
                if (this.isThreadSafe()) {
                    ScriptingContainer scriptingContainer = script.getContainer();
                    synchronized (scriptingContainer) {
                        result = this.executeImpl(script, variables);
                        break block7;
                    }
                }
                result = this.executeImpl(script, variables);
            }
            catch (RuntimeException ex) {
                throw new ScriptRuntimeException((Throwable)ex);
            }
        }
        LOGGER.finer("returned: {0}", new Object[]{result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledRubyScript getCompiledScript() {
        CompiledRubyScript localScript = this.compiledScript;
        if (localScript == null) {
            RubyScript rubyScript = this;
            synchronized (rubyScript) {
                localScript = this.compiledScript;
                if (localScript == null) {
                    this.compiledScript = this.isCached() ? SCRIPT_CACHE.computeIfAbsent(this.getCode(), this::compileScript) : this.compileScript(this.getCode());
                    localScript = this.compiledScript;
                }
            }
        }
        return localScript;
    }

    protected CompiledRubyScript compileScript(String code) {
        try {
            LOGGER.fine("compiling script:\n{0}", new Object[]{code});
            EmbedEvalUnit rubyScript = this.container.parse(code, new int[0]);
            return new CompiledRubyScript(this.container, code, rubyScript);
        }
        catch (RuntimeException ex) {
            throw new ScriptRuntimeException("parsing failed: " + (Object)((Object)this), (Throwable)ex);
        }
    }

    protected <T> T executeImpl(CompiledRubyScript script, Collection<ScriptVariable> variables) {
        IRubyObject rubyResult;
        if (variables != null) {
            for (ScriptVariable variable : variables) {
                script.getContainer().put(this.getLanguage().createLocalVariableReference(variable.getName()), variable.getValue());
            }
        }
        return (T)((rubyResult = script.getRubyScript().run()) == null ? null : rubyResult.toJava(rubyResult.getJavaClass()));
    }
}

