/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script.ruby;

import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;
import org.tentackle.log.Logger;
import org.tentackle.script.AbstractScript;
import org.tentackle.script.ScriptRuntimeException;
import org.tentackle.script.ScriptVariable;
import org.tentackle.script.ScriptingLanguage;
import org.tentackle.script.ruby.RubyLanguage;

public class RubyScript
extends AbstractScript {
    private static final long serialVersionUID = -7188401350915879268L;
    private static final Logger LOGGER = Logger.get(RubyScript.class);
    private volatile CompiledScript compiledScript;
    private boolean executed;
    private Object result;

    public RubyScript(RubyLanguage language) {
        super((ScriptingLanguage)language, false);
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript == null ? this.parse() : this.compiledScript;
    }

    public boolean isParsed() {
        return this.compiledScript != null;
    }

    public void clearParsed() {
        this.compiledScript = null;
    }

    public CompiledScript parse() {
        try {
            String effectiveCode = this.getEffectiveCode();
            LOGGER.fine("compiling script:\n{0}", new Object[]{effectiveCode});
            ScriptingContainer container = new ScriptingContainer();
            EmbedEvalUnit script = container.parse(effectiveCode, new int[0]);
            this.compiledScript = new CompiledScript(container, effectiveCode, script);
            return this.compiledScript;
        }
        catch (RuntimeException ex) {
            throw new ScriptRuntimeException("parsing failed: " + this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ScriptVariable ... variables) {
        block6: {
            this.executed = false;
            this.result = null;
            CompiledScript script = this.getCompiledScript();
            LOGGER.finer(() -> "execute: \n" + script.getEffectiveCode() + "\nwith args: " + ScriptVariable.variablesToString((ScriptVariable[])variables));
            try {
                if (this.isThreadSafe()) {
                    CompiledScript compiledScript = script;
                    synchronized (compiledScript) {
                        this.result = this.executeImpl(script, variables);
                        break block6;
                    }
                }
                this.result = this.executeImpl(script, variables);
            }
            catch (RuntimeException ex) {
                throw new ScriptRuntimeException((Throwable)ex);
            }
        }
        LOGGER.finer("returned: {0}", new Object[]{this.result});
        this.executed = true;
    }

    public Object getResult() {
        if (!this.executed) {
            throw new ScriptRuntimeException("script not executed");
        }
        return this.result;
    }

    private Object executeImpl(CompiledScript script, ScriptVariable ... variables) {
        IRubyObject rubyResult;
        if (variables != null) {
            for (ScriptVariable variable : variables) {
                script.getContainer().put(this.getLanguage().createLocalVariableReference(variable.getName()), variable.getValue());
            }
        }
        return (rubyResult = script.getRubyScript().run()) == null ? null : rubyResult.toJava(rubyResult.getJavaClass());
    }

    public static class CompiledScript {
        private final ScriptingContainer container;
        private final String effectiveCode;
        private final EmbedEvalUnit rubyScript;

        public CompiledScript(ScriptingContainer container, String effectiveCode, EmbedEvalUnit rubyScript) {
            this.container = container;
            this.effectiveCode = effectiveCode;
            this.rubyScript = rubyScript;
        }

        public ScriptingContainer getContainer() {
            return this.container;
        }

        public String getEffectiveCode() {
            return this.effectiveCode;
        }

        public EmbedEvalUnit getRubyScript() {
            return this.rubyScript;
        }
    }
}

