/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.nnapi;

import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.TensorFlowLite;

public class NnApiDelegate
implements Delegate,
AutoCloseable {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private long delegateHandle;

    public NnApiDelegate(Options options) {
        TensorFlowLite.init();
        this.delegateHandle = NnApiDelegate.createDelegate(options.executionPreference, options.acceleratorName, options.cacheDir, options.modelToken, options.maxDelegatedPartitions != null ? options.maxDelegatedPartitions : -1, options.useNnapiCpu != null, options.useNnapiCpu != null ? !options.useNnapiCpu.booleanValue() : true, options.allowFp16 != null ? options.allowFp16 : false);
    }

    public NnApiDelegate() {
        this(new Options());
    }

    @Override
    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            NnApiDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    public int getNnapiErrno() {
        this.checkNotClosed();
        return NnApiDelegate.getNnapiErrno(this.delegateHandle);
    }

    public boolean hasErrors() {
        return NnApiDelegate.getNnapiErrno(this.delegateHandle) != 0;
    }

    private void checkNotClosed() {
        if (this.delegateHandle == 0L) {
            throw new IllegalStateException("Should not access delegate after it has been closed.");
        }
    }

    private static native long createDelegate(int var0, String var1, String var2, String var3, int var4, boolean var5, boolean var6, boolean var7);

    private static native void deleteDelegate(long var0);

    private static native int getNnapiErrno(long var0);

    public static final class Options {
        public static final int EXECUTION_PREFERENCE_UNDEFINED = -1;
        public static final int EXECUTION_PREFERENCE_LOW_POWER = 0;
        public static final int EXECUTION_PREFERENCE_FAST_SINGLE_ANSWER = 1;
        public static final int EXECUTION_PREFERENCE_SUSTAINED_SPEED = 2;
        private int executionPreference = -1;
        private String acceleratorName = null;
        private String cacheDir = null;
        private String modelToken = null;
        private Integer maxDelegatedPartitions = null;
        private Boolean useNnapiCpu = null;
        private Boolean allowFp16 = null;

        public Options setExecutionPreference(int preference) {
            this.executionPreference = preference;
            return this;
        }

        public Options setAcceleratorName(String name) {
            this.acceleratorName = name;
            return this;
        }

        public Options setCacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Options setModelToken(String modelToken) {
            this.modelToken = modelToken;
            return this;
        }

        public Options setMaxNumberOfDelegatedPartitions(int limit) {
            this.maxDelegatedPartitions = limit;
            return this;
        }

        public Options setUseNnapiCpu(boolean enable) {
            this.useNnapiCpu = !enable;
            return this;
        }

        public Options setAllowFp16(boolean enable) {
            this.allowFp16 = enable;
            return this;
        }
    }
}

