/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.nnapi;

import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.TensorFlowLite;
import org.tensorflow.lite.nnapi.NnApiDelegate;

public class NnApiDelegateImpl
implements NnApiDelegate.PrivateInterface,
Delegate,
AutoCloseable {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private long delegateHandle;

    public NnApiDelegateImpl(NnApiDelegate.Options options) {
        TensorFlowLite.init();
        this.delegateHandle = NnApiDelegateImpl.createDelegate(options.getExecutionPreference(), options.getAcceleratorName(), options.getCacheDir(), options.getModelToken(), options.getMaxNumberOfDelegatedPartitions(), options.getUseNnapiCpu() != null, options.getUseNnapiCpu() != null ? !options.getUseNnapiCpu().booleanValue() : true, options.getAllowFp16(), options.getNnApiSupportLibraryHandle());
    }

    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            NnApiDelegateImpl.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    public int getNnapiErrno() {
        this.checkNotClosed();
        return NnApiDelegateImpl.getNnapiErrno(this.delegateHandle);
    }

    private void checkNotClosed() {
        if (this.delegateHandle == 0L) {
            throw new IllegalStateException("Should not access delegate after it has been closed.");
        }
    }

    private static native long createDelegate(int var0, String var1, String var2, String var3, int var4, boolean var5, boolean var6, boolean var7, long var8);

    private static native void deleteDelegate(long var0);

    private static native int getNnapiErrno(long var0);
}

