/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.Tensor;

public final class Interpreter
implements AutoCloseable {
    NativeInterpreterWrapper wrapper;

    public Interpreter(@NonNull File modelFile) {
        if (modelFile == null) {
            return;
        }
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath());
    }

    public Interpreter(@NonNull File modelFile, int numThreads) {
        if (modelFile == null) {
            return;
        }
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath(), numThreads);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer, int numThreads) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer, numThreads);
    }

    public Interpreter(@NonNull MappedByteBuffer mappedByteBuffer) {
        this.wrapper = new NativeInterpreterWrapper(mappedByteBuffer);
    }

    public Interpreter(@NonNull MappedByteBuffer mappedByteBuffer, int numThreads) {
        this.wrapper = new NativeInterpreterWrapper(mappedByteBuffer, numThreads);
    }

    public void run(@NonNull Object input, @NonNull Object output) {
        Object[] inputs = new Object[]{input};
        HashMap<Integer, Object> outputs = new HashMap<Integer, Object>();
        outputs.put(0, output);
        this.runForMultipleInputsOutputs(inputs, outputs);
    }

    public void runForMultipleInputsOutputs(@NonNull Object[] inputs, @NonNull Map<Integer, Object> outputs) {
        this.checkNotClosed();
        this.wrapper.run(inputs, outputs);
    }

    public void resizeInput(int idx, @NonNull int[] dims) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims);
    }

    public int getInputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getInputTensorCount();
    }

    public int getInputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getInputIndex(opName);
    }

    public Tensor getInputTensor(int inputIndex) {
        this.checkNotClosed();
        return this.wrapper.getInputTensor(inputIndex);
    }

    public int getOutputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getOutputTensorCount();
    }

    public int getOutputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getOutputIndex(opName);
    }

    public Tensor getOutputTensor(int outputIndex) {
        this.checkNotClosed();
        return this.wrapper.getOutputTensor(outputIndex);
    }

    public Long getLastNativeInferenceDurationNanoseconds() {
        this.checkNotClosed();
        return this.wrapper.getLastNativeInferenceDurationNanoseconds();
    }

    public void setUseNNAPI(boolean useNNAPI) {
        this.checkNotClosed();
        this.wrapper.setUseNNAPI(useNNAPI);
    }

    public void setNumThreads(int numThreads) {
        this.checkNotClosed();
        this.wrapper.setNumThreads(numThreads);
    }

    @Override
    public void close() {
        if (this.wrapper != null) {
            this.wrapper.close();
            this.wrapper = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Internal error: The Interpreter has already been closed.");
        }
    }
}

