/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tensorflow.lite.Tensor;
import org.tensorflow.lite.TensorFlowLite;

final class NativeInterpreterWrapper
implements AutoCloseable {
    private static final int ERROR_BUFFER_SIZE = 512;
    private long errorHandle;
    private long interpreterHandle;
    private long modelHandle;
    private long inferenceDurationNanoseconds = -1L;
    private ByteBuffer modelByteBuffer;
    private Map<String, Integer> inputsIndexes;
    private Map<String, Integer> outputsIndexes;
    private final Tensor[] inputTensors;
    private final Tensor[] outputTensors;
    private boolean isMemoryAllocated = false;

    NativeInterpreterWrapper(String modelPath) {
        this(modelPath, -1);
    }

    NativeInterpreterWrapper(String modelPath, int numThreads) {
        this.errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        this.modelHandle = NativeInterpreterWrapper.createModel(modelPath, this.errorHandle);
        this.interpreterHandle = NativeInterpreterWrapper.createInterpreter(this.modelHandle, this.errorHandle, numThreads);
        this.isMemoryAllocated = true;
        this.inputTensors = new Tensor[NativeInterpreterWrapper.getInputCount(this.interpreterHandle)];
        this.outputTensors = new Tensor[NativeInterpreterWrapper.getOutputCount(this.interpreterHandle)];
    }

    NativeInterpreterWrapper(ByteBuffer byteBuffer) {
        this(byteBuffer, -1);
    }

    NativeInterpreterWrapper(ByteBuffer buffer, int numThreads) {
        if (buffer == null || !(buffer instanceof MappedByteBuffer) && (!buffer.isDirect() || buffer.order() != ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Model ByteBuffer should be either a MappedByteBuffer of the model file, or a direct ByteBuffer using ByteOrder.nativeOrder() which contains bytes of model content.");
        }
        this.modelByteBuffer = buffer;
        this.errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        this.modelHandle = NativeInterpreterWrapper.createModelWithBuffer(this.modelByteBuffer, this.errorHandle);
        this.interpreterHandle = NativeInterpreterWrapper.createInterpreter(this.modelHandle, this.errorHandle, numThreads);
        this.isMemoryAllocated = true;
        this.inputTensors = new Tensor[NativeInterpreterWrapper.getInputCount(this.interpreterHandle)];
        this.outputTensors = new Tensor[NativeInterpreterWrapper.getOutputCount(this.interpreterHandle)];
    }

    @Override
    public void close() {
        NativeInterpreterWrapper.delete(this.errorHandle, this.modelHandle, this.interpreterHandle);
        this.errorHandle = 0L;
        this.modelHandle = 0L;
        this.interpreterHandle = 0L;
        this.modelByteBuffer = null;
        this.inputsIndexes = null;
        this.outputsIndexes = null;
        this.isMemoryAllocated = false;
        Arrays.fill(this.inputTensors, null);
        Arrays.fill(this.outputTensors, null);
    }

    void run(Object[] inputs, Map<Integer, Object> outputs) {
        int i;
        this.inferenceDurationNanoseconds = -1L;
        if (inputs == null || inputs.length == 0) {
            throw new IllegalArgumentException("Input error: Inputs should not be null or empty.");
        }
        if (outputs == null || outputs.isEmpty()) {
            throw new IllegalArgumentException("Input error: Outputs should not be null or empty.");
        }
        for (i = 0; i < inputs.length; ++i) {
            Tensor tensor = this.getInputTensor(i);
            int[] newShape = tensor.getInputShapeIfDifferent(inputs[i]);
            if (newShape == null) continue;
            this.resizeInput(i, newShape);
        }
        if (!this.isMemoryAllocated) {
            NativeInterpreterWrapper.allocateTensors(this.interpreterHandle, this.errorHandle);
            this.isMemoryAllocated = true;
            Arrays.fill(this.outputTensors, null);
        }
        for (i = 0; i < inputs.length; ++i) {
            this.getInputTensor(i).setTo(inputs[i]);
        }
        long inferenceStartNanos = System.nanoTime();
        NativeInterpreterWrapper.run(this.interpreterHandle, this.errorHandle);
        long inferenceDurationNanoseconds = System.nanoTime() - inferenceStartNanos;
        for (Map.Entry<Integer, Object> output : outputs.entrySet()) {
            this.getOutputTensor(output.getKey()).copyTo(output.getValue());
        }
        this.inferenceDurationNanoseconds = inferenceDurationNanoseconds;
    }

    private static native boolean run(long var0, long var2);

    void resizeInput(int idx, int[] dims) {
        if (NativeInterpreterWrapper.resizeInput(this.interpreterHandle, this.errorHandle, idx, dims)) {
            this.isMemoryAllocated = false;
            this.inputTensors[idx] = null;
        }
    }

    private static native boolean resizeInput(long var0, long var2, int var4, int[] var5);

    void setUseNNAPI(boolean useNNAPI) {
        NativeInterpreterWrapper.useNNAPI(this.interpreterHandle, useNNAPI);
    }

    void setNumThreads(int numThreads) {
        NativeInterpreterWrapper.numThreads(this.interpreterHandle, numThreads);
    }

    int getInputIndex(String name) {
        if (this.inputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getInputNames(this.interpreterHandle);
            this.inputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.inputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.inputsIndexes.containsKey(name)) {
            return this.inputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any input. Names of inputs and their indexes are %s", name, this.inputsIndexes.toString()));
    }

    int getOutputIndex(String name) {
        if (this.outputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getOutputNames(this.interpreterHandle);
            this.outputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.outputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.outputsIndexes.containsKey(name)) {
            return this.outputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any output. Names of outputs and their indexes are %s", name, this.outputsIndexes.toString()));
    }

    Long getLastNativeInferenceDurationNanoseconds() {
        return this.inferenceDurationNanoseconds < 0L ? null : Long.valueOf(this.inferenceDurationNanoseconds);
    }

    int getOutputQuantizationZeroPoint(int index) {
        return NativeInterpreterWrapper.getOutputQuantizationZeroPoint(this.interpreterHandle, index);
    }

    float getOutputQuantizationScale(int index) {
        return NativeInterpreterWrapper.getOutputQuantizationScale(this.interpreterHandle, index);
    }

    Tensor getInputTensor(int index) {
        if (index < 0 || index >= this.inputTensors.length) {
            throw new IllegalArgumentException("Invalid input Tensor index: " + index);
        }
        Tensor inputTensor = this.inputTensors[index];
        if (inputTensor == null) {
            inputTensor = this.inputTensors[index] = Tensor.fromHandle(NativeInterpreterWrapper.getInputTensor(this.interpreterHandle, index));
        }
        return inputTensor;
    }

    Tensor getOutputTensor(int index) {
        if (index < 0 || index >= this.outputTensors.length) {
            throw new IllegalArgumentException("Invalid output Tensor index: " + index);
        }
        Tensor outputTensor = this.outputTensors[index];
        if (outputTensor == null) {
            outputTensor = this.outputTensors[index] = Tensor.fromHandle(NativeInterpreterWrapper.getOutputTensor(this.interpreterHandle, index));
        }
        return outputTensor;
    }

    private static native int getOutputDataType(long var0, int var2);

    private static native int getOutputQuantizationZeroPoint(long var0, int var2);

    private static native float getOutputQuantizationScale(long var0, int var2);

    private static native long allocateTensors(long var0, long var2);

    private static native long getInputTensor(long var0, int var2);

    private static native long getOutputTensor(long var0, int var2);

    private static native int getInputCount(long var0);

    private static native int getOutputCount(long var0);

    private static native String[] getInputNames(long var0);

    private static native String[] getOutputNames(long var0);

    private static native void useNNAPI(long var0, boolean var2);

    private static native void numThreads(long var0, int var2);

    private static native long createErrorReporter(int var0);

    private static native long createModel(String var0, long var1);

    private static native long createModelWithBuffer(ByteBuffer var0, long var1);

    private static native long createInterpreter(long var0, long var2, int var4);

    private static native void delete(long var0, long var2, long var4);

    static {
        TensorFlowLite.init();
    }
}

