/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.ReshapeOptionsT;

public final class ReshapeOptions
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static ReshapeOptions getRootAsReshapeOptions(ByteBuffer _bb) {
        return ReshapeOptions.getRootAsReshapeOptions(_bb, new ReshapeOptions());
    }

    public static ReshapeOptions getRootAsReshapeOptions(ByteBuffer _bb, ReshapeOptions obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public ReshapeOptions __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int newShape(int j) {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int newShapeLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector newShapeVector() {
        return this.newShapeVector(new IntVector());
    }

    public IntVector newShapeVector(IntVector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer newShapeAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public ByteBuffer newShapeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 4);
    }

    public static int createReshapeOptions(FlatBufferBuilder builder, int newShapeOffset) {
        builder.startTable(1);
        ReshapeOptions.addNewShape(builder, newShapeOffset);
        return ReshapeOptions.endReshapeOptions(builder);
    }

    public static void startReshapeOptions(FlatBufferBuilder builder) {
        builder.startTable(1);
    }

    public static void addNewShape(FlatBufferBuilder builder, int newShapeOffset) {
        builder.addOffset(0, newShapeOffset, 0);
    }

    public static int createNewShapeVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startNewShapeVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endReshapeOptions(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public ReshapeOptionsT unpack() {
        ReshapeOptionsT _o = new ReshapeOptionsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(ReshapeOptionsT _o) {
        int[] _oNewShape = new int[this.newShapeLength()];
        for (int _j = 0; _j < this.newShapeLength(); ++_j) {
            _oNewShape[_j] = this.newShape(_j);
        }
        _o.setNewShape(_oNewShape);
    }

    public static int pack(FlatBufferBuilder builder, ReshapeOptionsT _o) {
        if (_o == null) {
            return 0;
        }
        int _newShape = 0;
        if (_o.getNewShape() != null) {
            _newShape = ReshapeOptions.createNewShapeVector(builder, _o.getNewShape());
        }
        return ReshapeOptions.createReshapeOptions(builder, _newShape);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public ReshapeOptions get(int j) {
            return this.get(new ReshapeOptions(), j);
        }

        public ReshapeOptions get(ReshapeOptions obj, int j) {
            return obj.__assign(ReshapeOptions.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

