/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.QuantizationParameters;
import org.tensorflow.lite.schema.SparsityParameters;
import org.tensorflow.lite.schema.TensorT;

public final class Tensor
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static Tensor getRootAsTensor(ByteBuffer _bb) {
        return Tensor.getRootAsTensor(_bb, new Tensor());
    }

    public static Tensor getRootAsTensor(ByteBuffer _bb, Tensor obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public Tensor __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int shape(int j) {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int shapeLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector shapeVector() {
        return this.shapeVector(new IntVector());
    }

    public IntVector shapeVector(IntVector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer shapeAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public ByteBuffer shapeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 4);
    }

    public byte type() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public long buffer() {
        int o = this.__offset(8);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public String name() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer nameAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer nameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public QuantizationParameters quantization() {
        return this.quantization(new QuantizationParameters());
    }

    public QuantizationParameters quantization(QuantizationParameters obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public boolean isVariable() {
        int o = this.__offset(14);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public SparsityParameters sparsity() {
        return this.sparsity(new SparsityParameters());
    }

    public SparsityParameters sparsity(SparsityParameters obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public int shapeSignature(int j) {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int shapeSignatureLength() {
        int o = this.__offset(18);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector shapeSignatureVector() {
        return this.shapeSignatureVector(new IntVector());
    }

    public IntVector shapeSignatureVector(IntVector obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer shapeSignatureAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 4);
    }

    public ByteBuffer shapeSignatureInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 4);
    }

    public static int createTensor(FlatBufferBuilder builder, int shapeOffset, byte type, long buffer, int nameOffset, int quantizationOffset, boolean isVariable, int sparsityOffset, int shapeSignatureOffset) {
        builder.startTable(8);
        Tensor.addShapeSignature(builder, shapeSignatureOffset);
        Tensor.addSparsity(builder, sparsityOffset);
        Tensor.addQuantization(builder, quantizationOffset);
        Tensor.addName(builder, nameOffset);
        Tensor.addBuffer(builder, buffer);
        Tensor.addShape(builder, shapeOffset);
        Tensor.addIsVariable(builder, isVariable);
        Tensor.addType(builder, type);
        return Tensor.endTensor(builder);
    }

    public static void startTensor(FlatBufferBuilder builder) {
        builder.startTable(8);
    }

    public static void addShape(FlatBufferBuilder builder, int shapeOffset) {
        builder.addOffset(0, shapeOffset, 0);
    }

    public static int createShapeVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startShapeVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addType(FlatBufferBuilder builder, byte type) {
        builder.addByte(1, type, 0);
    }

    public static void addBuffer(FlatBufferBuilder builder, long buffer) {
        builder.addInt(2, (int)buffer, 0);
    }

    public static void addName(FlatBufferBuilder builder, int nameOffset) {
        builder.addOffset(3, nameOffset, 0);
    }

    public static void addQuantization(FlatBufferBuilder builder, int quantizationOffset) {
        builder.addOffset(4, quantizationOffset, 0);
    }

    public static void addIsVariable(FlatBufferBuilder builder, boolean isVariable) {
        builder.addBoolean(5, isVariable, false);
    }

    public static void addSparsity(FlatBufferBuilder builder, int sparsityOffset) {
        builder.addOffset(6, sparsityOffset, 0);
    }

    public static void addShapeSignature(FlatBufferBuilder builder, int shapeSignatureOffset) {
        builder.addOffset(7, shapeSignatureOffset, 0);
    }

    public static int createShapeSignatureVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startShapeSignatureVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endTensor(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public TensorT unpack() {
        TensorT _o = new TensorT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(TensorT _o) {
        int[] _oShape = new int[this.shapeLength()];
        for (int _j = 0; _j < this.shapeLength(); ++_j) {
            _oShape[_j] = this.shape(_j);
        }
        _o.setShape(_oShape);
        byte _oType = this.type();
        _o.setType(_oType);
        long _oBuffer = this.buffer();
        _o.setBuffer(_oBuffer);
        String _oName = this.name();
        _o.setName(_oName);
        if (this.quantization() != null) {
            _o.setQuantization(this.quantization().unpack());
        } else {
            _o.setQuantization(null);
        }
        boolean _oIsVariable = this.isVariable();
        _o.setIsVariable(_oIsVariable);
        if (this.sparsity() != null) {
            _o.setSparsity(this.sparsity().unpack());
        } else {
            _o.setSparsity(null);
        }
        int[] _oShapeSignature = new int[this.shapeSignatureLength()];
        for (int _j = 0; _j < this.shapeSignatureLength(); ++_j) {
            _oShapeSignature[_j] = this.shapeSignature(_j);
        }
        _o.setShapeSignature(_oShapeSignature);
    }

    public static int pack(FlatBufferBuilder builder, TensorT _o) {
        if (_o == null) {
            return 0;
        }
        int _shape = 0;
        if (_o.getShape() != null) {
            _shape = Tensor.createShapeVector(builder, _o.getShape());
        }
        int _name = _o.getName() == null ? 0 : builder.createString((CharSequence)_o.getName());
        int _quantization = _o.getQuantization() == null ? 0 : QuantizationParameters.pack(builder, _o.getQuantization());
        int _sparsity = _o.getSparsity() == null ? 0 : SparsityParameters.pack(builder, _o.getSparsity());
        int _shapeSignature = 0;
        if (_o.getShapeSignature() != null) {
            _shapeSignature = Tensor.createShapeSignatureVector(builder, _o.getShapeSignature());
        }
        return Tensor.createTensor(builder, _shape, _o.getType(), _o.getBuffer(), _name, _quantization, _o.getIsVariable(), _sparsity, _shapeSignature);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public Tensor get(int j) {
            return this.get(new Tensor(), j);
        }

        public Tensor get(Tensor obj, int j) {
            return obj.__assign(Tensor.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

