/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.ZipException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tensorflow.lite.schema.Tensor;
import org.tensorflow.lite.support.metadata.ByteBufferChannel;
import org.tensorflow.lite.support.metadata.ModelInfo;
import org.tensorflow.lite.support.metadata.ModelMetadataInfo;
import org.tensorflow.lite.support.metadata.Preconditions;
import org.tensorflow.lite.support.metadata.ZipFile;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;

public class MetadataExtractor {
    private final ModelInfo modelInfo;
    @Nullable
    private final ModelMetadataInfo metadataInfo;
    @Nullable
    private final ZipFile zipFile;

    public MetadataExtractor(ByteBuffer buffer) throws IOException {
        this.modelInfo = new ModelInfo(buffer);
        ByteBuffer metadataBuffer = this.modelInfo.getMetadataBuffer();
        if (metadataBuffer != null) {
            this.metadataInfo = new ModelMetadataInfo(metadataBuffer);
            if (!this.isMinimumParserVersionSatisfied()) {
                System.err.printf("<Warning> Some fields in the metadata belong to a future schema. The minimum parser version required is %s, but the version of the current metadata parser is %s", this.metadataInfo.getMininumParserVersion(), "1.3.0");
            }
            Preconditions.checkArgument(this.modelInfo.getInputTensorCount() == this.metadataInfo.getInputTensorCount(), String.format("The number of input tensors in the model is %d. The number of input tensors that recorded in the metadata is %d. These two values does not match.", this.modelInfo.getInputTensorCount(), this.metadataInfo.getInputTensorCount()));
            Preconditions.checkArgument(this.modelInfo.getOutputTensorCount() == this.metadataInfo.getOutputTensorCount(), String.format("The number of output tensors in the model is %d. The number of output tensors that recorded in the metadata is %d. These two values does not match.", this.modelInfo.getOutputTensorCount(), this.metadataInfo.getOutputTensorCount()));
        } else {
            this.metadataInfo = null;
        }
        this.zipFile = MetadataExtractor.createZipFile(buffer);
    }

    public boolean hasMetadata() {
        return this.metadataInfo != null;
    }

    public InputStream getAssociatedFile(String fileName) {
        this.assertZipFile();
        return this.zipFile.getRawInputStream(fileName);
    }

    public Set<String> getAssociatedFileNames() {
        this.assertZipFile();
        return this.zipFile.getFileNames();
    }

    public int getInputTensorCount() {
        return this.modelInfo.getInputTensorCount();
    }

    @Nullable
    public TensorMetadata getInputTensorMetadata(int inputIndex) {
        this.assertMetadataInfo();
        return this.metadataInfo.getInputTensorMetadata(inputIndex);
    }

    public QuantizationParams getInputTensorQuantizationParams(int inputIndex) {
        Tensor tensor = this.modelInfo.getInputTensor(inputIndex);
        return this.modelInfo.getQuantizationParams(tensor);
    }

    public int[] getInputTensorShape(int inputIndex) {
        return this.modelInfo.getInputTensorShape(inputIndex);
    }

    public byte getInputTensorType(int inputIndex) {
        return this.modelInfo.getInputTensorType(inputIndex);
    }

    public ModelMetadata getModelMetadata() {
        this.assertMetadataInfo();
        return this.metadataInfo.getModelMetadata();
    }

    public int getOutputTensorCount() {
        return this.modelInfo.getOutputTensorCount();
    }

    @Nullable
    public TensorMetadata getOutputTensorMetadata(int outputIndex) {
        this.assertMetadataInfo();
        return this.metadataInfo.getOutputTensorMetadata(outputIndex);
    }

    public QuantizationParams getOutputTensorQuantizationParams(int outputIndex) {
        Tensor tensor = this.modelInfo.getOutputTensor(outputIndex);
        return this.modelInfo.getQuantizationParams(tensor);
    }

    public int[] getOutputTensorShape(int outputIndex) {
        return this.modelInfo.getOutputTensorShape(outputIndex);
    }

    public byte getOutputTensorType(int outputIndex) {
        return this.modelInfo.getOutputTensorType(outputIndex);
    }

    public final boolean isMinimumParserVersionSatisfied() {
        String minVersion = this.metadataInfo.getMininumParserVersion();
        if (minVersion == null) {
            return true;
        }
        return MetadataExtractor.compareVersions(minVersion, "1.3.0") <= 0;
    }

    private void assertMetadataInfo() {
        if (this.metadataInfo == null) {
            throw new IllegalStateException("This model does not contain model metadata.");
        }
    }

    private void assertZipFile() {
        if (this.zipFile == null) {
            throw new IllegalStateException("This model does not contain associated files, and is not a Zip file.");
        }
    }

    @Nullable
    private static ZipFile createZipFile(ByteBuffer buffer) throws IOException {
        try {
            ByteBufferChannel byteBufferChannel = new ByteBufferChannel(buffer);
            return ZipFile.createFrom(byteBufferChannel);
        }
        catch (ZipException e) {
            return null;
        }
    }

    private static int compareVersions(String version1, String version2) {
        String[] levels1 = version1.split("\\.", 0);
        String[] levels2 = version2.split("\\.", 0);
        int length = Math.max(levels1.length, levels2.length);
        for (int i = 0; i < length; ++i) {
            Integer v2;
            Integer v1 = i < levels1.length ? Integer.parseInt(levels1[i]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i < levels2.length ? Integer.parseInt(levels2[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static class QuantizationParams {
        private final float scale;
        private final int zeroPoint;

        public QuantizationParams(float scale, int zeroPoint) {
            this.scale = scale;
            this.zeroPoint = zeroPoint;
        }

        public float getScale() {
            return this.scale;
        }

        public int getZeroPoint() {
            return this.zeroPoint;
        }
    }
}

