/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Tensor;

public interface InterpreterApi
extends AutoCloseable {
    public void run(Object var1, Object var2);

    public void runForMultipleInputsOutputs(Object @NonNull [] var1, @NonNull Map<Integer, Object> var2);

    public void allocateTensors();

    public void resizeInput(int var1, @NonNull int[] var2);

    public void resizeInput(int var1, @NonNull int[] var2, boolean var3);

    public int getInputTensorCount();

    public int getInputIndex(String var1);

    public Tensor getInputTensor(int var1);

    public int getOutputTensorCount();

    public int getOutputIndex(String var1);

    public Tensor getOutputTensor(int var1);

    public Long getLastNativeInferenceDurationNanoseconds();

    @Override
    public void close();

    public static class Options {
        int numThreads = -1;
        Boolean useNNAPI;
        Boolean allowCancellation;
        final List<Delegate> delegates;

        public Options() {
            this.delegates = new ArrayList<Delegate>();
        }

        public Options(Options other) {
            this.numThreads = other.numThreads;
            this.useNNAPI = other.useNNAPI;
            this.allowCancellation = other.allowCancellation;
            this.delegates = new ArrayList<Delegate>(other.delegates);
        }

        public Options setNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public Options setUseNNAPI(boolean useNNAPI) {
            this.useNNAPI = useNNAPI;
            return this;
        }

        public boolean getUseNNAPI() {
            return this.useNNAPI != null && this.useNNAPI != false;
        }

        public Options setCancellable(boolean allow) {
            this.allowCancellation = allow;
            return this;
        }

        public boolean isCancellable() {
            return this.allowCancellation != null && this.allowCancellation != false;
        }

        public Options addDelegate(Delegate delegate) {
            this.delegates.add(delegate);
            return this;
        }

        public List<Delegate> getDelegates() {
            return Collections.unmodifiableList(this.delegates);
        }
    }
}

