/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.raw;

import java.util.Arrays;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.raw.AbstractRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.UnsafeMemoryHandle;

final class BooleanRawDataBuffer
extends AbstractRawDataBuffer<Boolean, BooleanDataBuffer>
implements BooleanDataBuffer {
    @Override
    public boolean getBoolean(long index) {
        Validator.getArgs(this, index);
        return this.memory.getBoolean(index);
    }

    @Override
    public BooleanDataBuffer setBoolean(boolean value, long index) {
        Validator.setArgs(this, index);
        this.memory.setBoolean(value, index);
        return this;
    }

    @Override
    public BooleanDataBuffer read(boolean[] dst) {
        return (BooleanDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public BooleanDataBuffer read(boolean[] dst, int offset, int length) {
        return (BooleanDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public BooleanDataBuffer write(boolean[] src) {
        return (BooleanDataBuffer)this.write(src, src.length);
    }

    @Override
    public BooleanDataBuffer write(boolean[] src, int offset, int length) {
        return (BooleanDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public BooleanDataBuffer copyTo(final DataBuffer<Boolean> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<BooleanDataBuffer>(){

            @Override
            public BooleanDataBuffer visit(boolean[] array, int offset, int length) {
                BooleanRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(array, offset, length), size);
                return BooleanRawDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer visit(long address, long length, long scale) {
                BooleanRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return BooleanRawDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer fallback() {
                if (dst instanceof BooleanDataBuffer) {
                    BooleanDataBuffer booleanDst = (BooleanDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        booleanDst.setBoolean(BooleanRawDataBuffer.this.getBoolean(idx), idx);
                    }
                    return BooleanRawDataBuffer.this;
                }
                return (BooleanDataBuffer)BooleanRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit((boolean[])this.memory.object, this.memory.arrayOffset(boolean[].class), (int)this.memory.size());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanDataBuffer)) {
            return super.equals(obj);
        }
        final BooleanDataBuffer other = (BooleanDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(boolean[] array, int offset, int length) {
                boolean[] thisArray;
                if (BooleanRawDataBuffer.this.memory.isArray() && BooleanRawDataBuffer.this.memory.arrayOffset(boolean[].class) == 0 && offset == 0 && (thisArray = (boolean[])BooleanRawDataBuffer.this.memory.array()).length == array.length) {
                    return Arrays.equals(thisArray, array);
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < BooleanRawDataBuffer.this.size(); ++idx) {
                    if (other.getBoolean(idx) == BooleanRawDataBuffer.this.getBoolean(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected BooleanDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new BooleanRawDataBuffer(memory, this.readOnly);
    }

    BooleanRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

