/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.buffer.DataBuffer;

public class Validator {
    public static void copyToNdArrayArgs(NdArray<?> ndArray, NdArray<?> otherNdArray) {
        if (!ndArray.shape().equals(otherNdArray.shape())) {
            throw new IllegalArgumentException("Can only copy to arrays of the same shape (" + ndArray.shape() + " != " + otherNdArray.shape() + ")");
        }
    }

    public static void readToBufferArgs(NdArray<?> ndArray, DataBuffer<?> dst) {
        if (dst.size() < ndArray.size()) {
            throw new BufferOverflowException();
        }
    }

    public static void writeFromBufferArgs(NdArray<?> ndArray, DataBuffer<?> src) {
        if (src.size() < ndArray.size()) {
            throw new BufferUnderflowException();
        }
    }

    private static void copyArrayArgs(int arrayLength, int arrayOffset) {
        if (arrayOffset < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (arrayOffset > arrayLength) {
            throw new IndexOutOfBoundsException("Offset must be no larger than array length");
        }
    }

    protected Validator() {
    }
}

