/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray;

import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.dense.BooleanDenseNdArray;
import org.tensorflow.ndarray.impl.dense.ByteDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DenseNdArray;
import org.tensorflow.ndarray.impl.dense.DoubleDenseNdArray;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.ndarray.impl.dense.IntDenseNdArray;
import org.tensorflow.ndarray.impl.dense.LongDenseNdArray;
import org.tensorflow.ndarray.impl.dense.ShortDenseNdArray;

public final class NdArrays {
    public static ByteNdArray scalarOf(byte value) {
        return NdArrays.ofBytes(Shape.scalar()).setByte(value, new long[0]);
    }

    public static ByteNdArray vectorOf(byte ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static ByteNdArray ofBytes(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape cannot be null");
        }
        return NdArrays.wrap(shape, DataBuffers.ofBytes(shape.size()));
    }

    public static ByteNdArray wrap(Shape shape, ByteDataBuffer buffer) {
        return ByteDenseNdArray.create(buffer, shape);
    }

    public static LongNdArray scalarOf(long value) {
        return NdArrays.ofLongs(Shape.scalar()).setLong(value, new long[0]);
    }

    public static LongNdArray vectorOf(long ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static LongNdArray ofLongs(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofLongs(shape.size()));
    }

    public static LongNdArray wrap(Shape shape, LongDataBuffer buffer) {
        return LongDenseNdArray.create(buffer, shape);
    }

    public static IntNdArray scalarOf(int value) {
        return NdArrays.ofInts(Shape.scalar()).setInt(value, new long[0]);
    }

    public static IntNdArray vectorOf(int ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static IntNdArray ofInts(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofInts(shape.size()));
    }

    public static IntNdArray wrap(Shape shape, IntDataBuffer buffer) {
        return IntDenseNdArray.create(buffer, shape);
    }

    public static ShortNdArray scalarOf(short value) {
        return NdArrays.ofShorts(Shape.scalar()).setShort(value, new long[0]);
    }

    public static ShortNdArray vectorOf(short ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static ShortNdArray ofShorts(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofShorts(shape.size()));
    }

    public static ShortNdArray wrap(Shape shape, ShortDataBuffer buffer) {
        return ShortDenseNdArray.create(buffer, shape);
    }

    public static FloatNdArray scalarOf(float value) {
        return NdArrays.ofFloats(Shape.scalar()).setFloat(value, new long[0]);
    }

    public static FloatNdArray vectorOf(float ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static FloatNdArray ofFloats(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofFloats(shape.size()));
    }

    public static FloatNdArray wrap(Shape shape, FloatDataBuffer buffer) {
        return FloatDenseNdArray.create(buffer, shape);
    }

    public static DoubleNdArray scalarOf(double value) {
        return NdArrays.ofDoubles(Shape.scalar()).setDouble(value, new long[0]);
    }

    public static DoubleNdArray vectorOf(double ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static DoubleNdArray ofDoubles(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofDoubles(shape.size()));
    }

    public static DoubleNdArray wrap(Shape shape, DoubleDataBuffer buffer) {
        return DoubleDenseNdArray.create(buffer, shape);
    }

    public static BooleanNdArray scalarOf(boolean value) {
        return NdArrays.ofBooleans(Shape.scalar()).setBoolean(value, new long[0]);
    }

    public static BooleanNdArray vectorOf(boolean ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static BooleanNdArray ofBooleans(Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofBooleans(shape.size()));
    }

    public static BooleanNdArray wrap(Shape shape, BooleanDataBuffer buffer) {
        return BooleanDenseNdArray.create(buffer, shape);
    }

    public static <T> NdArray<T> scalarOfObject(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return NdArrays.ofObjects(value.getClass(), Shape.scalar()).setObject(value, new long[0]);
    }

    @SafeVarargs
    public static <T> NdArray<T> vectorOfObjects(T ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Null or zero length input supplied to vectorOfObjects.");
        }
        return NdArrays.wrap(Shape.of(values.length), DataBuffers.of(values, false, false));
    }

    public static <T> NdArray<T> ofObjects(Class<T> clazz, Shape shape) {
        return NdArrays.wrap(shape, DataBuffers.ofObjects(clazz, shape.size()));
    }

    public static <T> NdArray<T> wrap(Shape shape, DataBuffer<T> buffer) {
        return DenseNdArray.wrap(buffer, shape);
    }
}

