/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import org.tensorflow.ndarray.IllegalRankException;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.index.All;
import org.tensorflow.ndarray.index.At;
import org.tensorflow.ndarray.index.Even;
import org.tensorflow.ndarray.index.Flip;
import org.tensorflow.ndarray.index.From;
import org.tensorflow.ndarray.index.Hyperslab;
import org.tensorflow.ndarray.index.Index;
import org.tensorflow.ndarray.index.Odd;
import org.tensorflow.ndarray.index.Range;
import org.tensorflow.ndarray.index.Sequence;
import org.tensorflow.ndarray.index.Step;
import org.tensorflow.ndarray.index.To;

public final class Indices {
    public static Index at(long coord) {
        return new At(coord);
    }

    public static Index at(NdArray<? extends Number> coord) {
        if (coord.rank() > 0) {
            throw new IllegalRankException("Only scalars are accepted as a value index");
        }
        return new At(coord.getObject(new long[0]).longValue());
    }

    public static Index all() {
        return All.INSTANCE;
    }

    public static Index seq(long ... coords) {
        if (coords == null) {
            throw new IllegalArgumentException();
        }
        return new Sequence(NdArrays.wrap(Shape.of(coords.length), DataBuffers.of(coords, true, false)));
    }

    public static Index seq(NdArray<? extends Number> coords) {
        if (coords.rank() != 1) {
            throw new IllegalRankException("Only vectors are accepted as an element index");
        }
        return new Sequence(coords);
    }

    public static Index even() {
        return Even.INSTANCE;
    }

    public static Index odd() {
        return Odd.INSTANCE;
    }

    public static Index step(long stepLength) {
        return new Step(stepLength);
    }

    public static Index from(long start) {
        return new From(start);
    }

    public static Index to(long end) {
        return new To(end);
    }

    public static Index range(long start, long end) {
        return new Range(start, end);
    }

    public static Index flip() {
        return Flip.INSTANCE;
    }

    public static Index hyperslab(long start, long stride, long count, long block) {
        return new Hyperslab(start, stride, count, block);
    }
}

