/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeArea
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> resizedImages;

    public static <T extends Number> ResizeArea create(Scope scope, Operand<T> images, Operand<Integer> size, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("ResizeArea", scope.makeOpName("ResizeArea"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners == null) continue;
                opBuilder.setAttr("align_corners", opts.alignCorners);
            }
        }
        return new ResizeArea(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public Output<Float> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<Float> asOutput() {
        return this.resizedImages;
    }

    private ResizeArea(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

