/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorArrayConcat<T>
extends PrimitiveOp {
    private Output<T> value;
    private Output<Long> lengths;

    public static <T> TensorArrayConcat<T> create(Scope scope, Operand<?> handle, Operand<Float> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("TensorArrayConcatV3", scope.makeOpName("TensorArrayConcat"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShapeExcept0 == null) continue;
                opBuilder.setAttr("element_shape_except0", opts.elementShapeExcept0);
            }
        }
        return new TensorArrayConcat<T>(opBuilder.build());
    }

    public static Options elementShapeExcept0(Shape elementShapeExcept0) {
        return new Options().elementShapeExcept0(elementShapeExcept0);
    }

    public Output<T> value() {
        return this.value;
    }

    public Output<Long> lengths() {
        return this.lengths;
    }

    private TensorArrayConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShapeExcept0;

        public Options elementShapeExcept0(Shape elementShapeExcept0) {
            this.elementShapeExcept0 = elementShapeExcept0;
            return this;
        }

        private Options() {
        }
    }
}

