/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class NameScope {
    private final String opPrefix;
    private final String opName;
    private final Map<String, Integer> ids;
    private static final Pattern NAME_REGEX = Pattern.compile("[A-Za-z0-9.][A-Za-z0-9_.\\-]*");

    NameScope withSubScope(String scopeName) {
        NameScope.checkPattern(NAME_REGEX, scopeName);
        String actualName = this.opName != null ? this.opName : scopeName;
        String newPrefix = this.fullyQualify(this.makeUnique(actualName));
        return new NameScope(newPrefix, null, null);
    }

    NameScope withName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        return new NameScope(this.opPrefix, name, this.ids);
    }

    String makeOpName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        String actualName = this.opName != null ? this.opName : name;
        return this.fullyQualify(this.makeUnique(actualName));
    }

    NameScope() {
        this(null, null, null);
    }

    private NameScope(String opPrefix, String opName, Map<String, Integer> ids) {
        this.opPrefix = opPrefix;
        this.opName = opName;
        this.ids = ids != null ? ids : new HashMap<String, Integer>();
    }

    private String makeUnique(String id) {
        if (!this.ids.containsKey(id)) {
            this.ids.put(id, 1);
            return id;
        }
        int cur = this.ids.get(id);
        this.ids.put(id, cur + 1);
        return String.format("%s_%d", id, cur);
    }

    private String fullyQualify(String name) {
        if (this.opPrefix != null) {
            return String.format("%s/%s", this.opPrefix, name);
        }
        return name;
    }

    private static void checkPattern(Pattern pattern, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Names cannot be null");
        }
        if (!pattern.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("invalid name: '%s' does not match the regular expression %s", name, NAME_REGEX.pattern()));
        }
    }
}

