/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Arrays;

public final class Shape {
    private long[] shape;

    public static Shape unknown() {
        return new Shape(null);
    }

    public static Shape scalar() {
        return new Shape(new long[0]);
    }

    public static Shape make(long firstDimensionSize, long ... otherDimensionSizes) {
        long[] shape = new long[otherDimensionSizes.length + 1];
        shape[0] = firstDimensionSize;
        System.arraycopy(otherDimensionSizes, 0, shape, 1, otherDimensionSizes.length);
        return new Shape(shape);
    }

    public int numDimensions() {
        return this.shape == null ? -1 : this.shape.length;
    }

    public long size(int i) {
        return this.shape[i];
    }

    public int hashCode() {
        return Arrays.hashCode(this.shape);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Shape && Arrays.equals(this.shape, ((Shape)obj).shape)) {
            return !this.hasUnknownDimension();
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.shape == null) {
            return "<unknown>";
        }
        return Arrays.toString(this.shape).replace("-1", "?");
    }

    Shape(long[] shape) {
        this.shape = shape;
    }

    long[] asArray() {
        return this.shape;
    }

    private boolean hasUnknownDimension() {
        if (this.shape == null) {
            return true;
        }
        for (long dimension : this.shape) {
            if (dimension != -1L) continue;
            return true;
        }
        return false;
    }
}

