/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Iterator;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.TensorFlow;

public final class Graph
implements AutoCloseable {
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int refcount = 0;

    public Graph() {
        this.nativeHandle = Graph.allocate();
    }

    Graph(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation operation(String name) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            long oph = Graph.operation(this.nativeHandle, name);
            if (oph == 0L) {
                return null;
            }
            return new Operation(this, oph);
        }
    }

    public Iterator<Operation> operations() {
        return new OperationIterator(this);
    }

    public OperationBuilder opBuilder(String type, String name) {
        return new OperationBuilder(this, type, name);
    }

    public void importGraphDef(byte[] graphDef) throws IllegalArgumentException {
        this.importGraphDef(graphDef, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGraphDef(byte[] graphDef, String prefix) throws IllegalArgumentException {
        if (graphDef == null || prefix == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, graphDef, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toGraphDef() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            return Graph.toGraphDef(this.nativeHandle);
        }
    }

    Reference ref() {
        return new Reference();
    }

    private static native long allocate();

    private static native void delete(long var0);

    private static native long operation(long var0, String var2);

    private static native long[] nextOperation(long var0, int var2);

    private static native void importGraphDef(long var0, byte[] var2, String var3) throws IllegalArgumentException;

    private static native byte[] toGraphDef(long var0);

    static {
        TensorFlow.init();
    }

    private static final class OperationIterator
    implements Iterator<Operation> {
        private final Graph graph;
        private Operation operation;
        private int position;

        OperationIterator(Graph g) {
            this.graph = g;
            this.operation = null;
            this.position = 0;
            this.advance();
        }

        private final void advance() {
            this.operation = null;
            try (Reference reference = this.graph.ref();){
                long[] nativeReturn = Graph.nextOperation(reference.nativeHandle(), this.position);
                if (nativeReturn != null && nativeReturn[0] != 0L) {
                    this.operation = new Operation(this.graph, nativeReturn[0]);
                    this.position = (int)nativeReturn[1];
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.operation != null;
        }

        @Override
        public Operation next() {
            Operation rhett = this.operation;
            this.advance();
            return rhett;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is unsupported.");
        }
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != 0L;
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                Graph.this.refcount++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : 0L;
            }
        }
    }
}

