/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseSplit<T>
extends PrimitiveOp {
    private List<Output<Long>> outputIndices;
    private List<Output<T>> outputValues;
    private List<Output<Long>> outputShape;

    public static <T> SparseSplit<T> create(Scope scope, Operand<Long> splitDim, Operand<Long> indices, Operand<T> values, Operand<Long> shape, Long numSplit) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseSplit", scope.makeOpName("SparseSplit"));
        opBuilder.addInput(splitDim.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_split", numSplit);
        return new SparseSplit<T>(opBuilder.build());
    }

    public List<Output<Long>> outputIndices() {
        return this.outputIndices;
    }

    public List<Output<T>> outputValues() {
        return this.outputValues;
    }

    public List<Output<Long>> outputShape() {
        return this.outputShape;
    }

    private SparseSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputIndicesLength = operation.outputListLength("output_indices");
        this.outputIndices = Arrays.asList(operation.outputList(outputIdx, outputIndicesLength));
        int outputValuesLength = operation.outputListLength("output_values");
        this.outputValues = Arrays.asList(operation.outputList(outputIdx += outputIndicesLength, outputValuesLength));
        int outputShapeLength = operation.outputListLength("output_shape");
        this.outputShape = Arrays.asList(operation.outputList(outputIdx += outputValuesLength, outputShapeLength));
        outputIdx += outputShapeLength;
    }
}

