/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesFlushQuantileSummaries
extends PrimitiveOp
implements Iterable<Operand<Float>> {
    private List<Output<Float>> summaries;

    public static BoostedTreesFlushQuantileSummaries create(Scope scope, Operand<?> quantileStreamResourceHandle, Long numFeatures) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesFlushQuantileSummaries", scope.makeOpName("BoostedTreesFlushQuantileSummaries"));
        opBuilder.addInput(quantileStreamResourceHandle.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_features", numFeatures);
        return new BoostedTreesFlushQuantileSummaries(opBuilder.build());
    }

    public List<Output<Float>> summaries() {
        return this.summaries;
    }

    @Override
    public Iterator<Operand<Float>> iterator() {
        return this.summaries.iterator();
    }

    private BoostedTreesFlushQuantileSummaries(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int summariesLength = operation.outputListLength("summaries");
        this.summaries = Arrays.asList(operation.outputList(outputIdx, summariesLength));
        outputIdx += summariesLength;
    }
}

