/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Re-configures the GCS block cache with the new configuration values.
 * <p>
 * If the values are the same as already configured values, this op is a no-op. If
 * they are different, the current contents of the block cache is dropped, and a
 * new block cache is created fresh.
 */
@Operator
public final class GcsConfigureBlockCache extends PrimitiveOp {
  
  /**
   * Factory method to create a class to wrap a new GcsConfigureBlockCache operation to the graph.
   * 
   * @param scope current graph scope
   * @param maxCacheSize 
   * @param blockSize 
   * @param maxStaleness 
   * @return a new instance of GcsConfigureBlockCache
   */
  public static GcsConfigureBlockCache create(Scope scope, Operand<?> maxCacheSize, Operand<?> blockSize, Operand<?> maxStaleness) {
    OperationBuilder opBuilder = scope.graph().opBuilder("GcsConfigureBlockCache", scope.makeOpName("GcsConfigureBlockCache"));
    opBuilder.addInput(maxCacheSize.asOutput());
    opBuilder.addInput(blockSize.asOutput());
    opBuilder.addInput(maxStaleness.asOutput());
    return new GcsConfigureBlockCache(opBuilder.build());
  }
  
  
  private GcsConfigureBlockCache(Operation operation) {
    super(operation);
  }
}
