/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Bitcasts a tensor from one type to another without copying data.
 * <p>
 * Given a tensor `input`, this operation returns a tensor that has the same buffer
 * data as `input` with datatype `type`.
 * <p>
 * If the input datatype `T` is larger than the output datatype `type` then the
 * shape changes from [...] to [..., sizeof(`T`)/sizeof(`type`)].
 * <p>
 * If `T` is smaller than `type`, the operator requires that the rightmost
 * dimension be equal to sizeof(`type`)/sizeof(`T`). The shape then goes from
 * [..., sizeof(`type`)/sizeof(`T`)] to [...].
 * <p>
 * <i>NOTE</i>: Bitcast is implemented as a low-level cast, so machines with different
 * endian orderings will give different results.
 * 
 * @param <U> data type for {@code output()} output
 */
@Operator
public final class Bitcast<U> extends PrimitiveOp implements Operand<U> {
  
  /**
   * Factory method to create a class to wrap a new Bitcast operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 
   * @param type 
   * @return a new instance of Bitcast
   */
  public static <U, T> Bitcast<U> create(Scope scope, Operand<T> input, Class<U> type) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Bitcast", scope.makeOpName("Bitcast"));
    opBuilder.addInput(input.asOutput());
    opBuilder.setAttr("type", DataType.fromClass(type));
    return new Bitcast<U>(opBuilder.build());
  }
  
  /**
   */
  public Output<U> output() {
    return output;
  }
  
  @Override
  public Output<U> asOutput() {
    return output;
  }
  
  private Output<U> output;
  
  private Bitcast(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
