/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedReshape<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T, U extends Number> QuantizedReshape<T> create(Scope scope, Operand<T> tensor, Operand<U> shape, Operand<Float> inputMin, Operand<Float> inputMax) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizedReshape", scope.makeOpName("QuantizedReshape"));
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        return new QuantizedReshape<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<Float> outputMin() {
        return this.outputMin;
    }

    public Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizedReshape(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }
}

