/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantize<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantize<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizeAndDequantize", scope.makeOpName("QuantizeAndDequantize"));
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.signedInput != null) {
                    opBuilder.setAttr("signed_input", opts.signedInput);
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.rangeGiven != null) {
                    opBuilder.setAttr("range_given", opts.rangeGiven);
                }
                if (opts.inputMin != null) {
                    opBuilder.setAttr("input_min", opts.inputMin.floatValue());
                }
                if (opts.inputMax == null) continue;
                opBuilder.setAttr("input_max", opts.inputMax.floatValue());
            }
        }
        return new QuantizeAndDequantize<T>(opBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options inputMin(Float inputMin) {
        return new Options().inputMin(inputMin);
    }

    public static Options inputMax(Float inputMax) {
        return new Options().inputMax(inputMax);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private Float inputMin;
        private Float inputMax;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options inputMin(Float inputMin) {
            this.inputMin = inputMin;
            return this;
        }

        public Options inputMax(Float inputMax) {
            this.inputMax = inputMax;
            return this;
        }

        private Options() {
        }
    }
}

