/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxArgsGradient
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> backprops;

    public static FakeQuantWithMinMaxArgsGradient create(Scope scope, Operand<Float> gradients, Operand<Float> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxArgsGradient", scope.makeOpName("FakeQuantWithMinMaxArgsGradient"));
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(inputs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.min != null) {
                    opBuilder.setAttr("min", opts.min.floatValue());
                }
                if (opts.max != null) {
                    opBuilder.setAttr("max", opts.max.floatValue());
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxArgsGradient(opBuilder.build());
    }

    public static Options min(Float min) {
        return new Options().min(min);
    }

    public static Options max(Float max) {
        return new Options().max(max);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<Float> backprops() {
        return this.backprops;
    }

    @Override
    public Output<Float> asOutput() {
        return this.backprops;
    }

    private FakeQuantWithMinMaxArgsGradient(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.backprops = operation.output(outputIdx++);
    }

    public static class Options {
        private Float min;
        private Float max;
        private Long numBits;
        private Boolean narrowRange;

        public Options min(Float min) {
            this.min = min;
            return this;
        }

        public Options max(Float max) {
            this.max = max;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

