/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SampleDistortedBoundingBoxV2<T extends Number>
extends PrimitiveOp {
    private Output<T> begin;
    private Output<T> size;
    private Output<Float> bboxes;

    public static <T extends Number> SampleDistortedBoundingBoxV2<T> create(Scope scope, Operand<T> imageSize, Operand<Float> boundingBoxes, Operand<Float> minObjectCovered, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SampleDistortedBoundingBoxV2", scope.makeOpName("SampleDistortedBoundingBoxV2"));
        opBuilder.addInput(imageSize.asOutput());
        opBuilder.addInput(boundingBoxes.asOutput());
        opBuilder.addInput(minObjectCovered.asOutput());
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.aspectRatioRange != null) {
                    float[] aspectRatioRangeArray = new float[opts.aspectRatioRange.size()];
                    for (i = 0; i < aspectRatioRangeArray.length; ++i) {
                        aspectRatioRangeArray[i] = ((Float)opts.aspectRatioRange.get(i)).floatValue();
                    }
                    opBuilder.setAttr("aspect_ratio_range", aspectRatioRangeArray);
                }
                if (opts.areaRange != null) {
                    float[] areaRangeArray = new float[opts.areaRange.size()];
                    for (i = 0; i < areaRangeArray.length; ++i) {
                        areaRangeArray[i] = ((Float)opts.areaRange.get(i)).floatValue();
                    }
                    opBuilder.setAttr("area_range", areaRangeArray);
                }
                if (opts.maxAttempts != null) {
                    opBuilder.setAttr("max_attempts", opts.maxAttempts);
                }
                if (opts.useImageIfNoBoundingBoxes == null) continue;
                opBuilder.setAttr("use_image_if_no_bounding_boxes", opts.useImageIfNoBoundingBoxes);
            }
        }
        return new SampleDistortedBoundingBoxV2<T>(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options aspectRatioRange(List<Float> aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options areaRange(List<Float> areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options maxAttempts(Long maxAttempts) {
        return new Options().maxAttempts(maxAttempts);
    }

    public static Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
        return new Options().useImageIfNoBoundingBoxes(useImageIfNoBoundingBoxes);
    }

    public Output<T> begin() {
        return this.begin;
    }

    public Output<T> size() {
        return this.size;
    }

    public Output<Float> bboxes() {
        return this.bboxes;
    }

    private SampleDistortedBoundingBoxV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.begin = operation.output(outputIdx++);
        this.size = operation.output(outputIdx++);
        this.bboxes = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;
        private List<Float> aspectRatioRange;
        private List<Float> areaRange;
        private Long maxAttempts;
        private Boolean useImageIfNoBoundingBoxes;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options aspectRatioRange(List<Float> aspectRatioRange) {
            this.aspectRatioRange = aspectRatioRange;
            return this;
        }

        public Options areaRange(List<Float> areaRange) {
            this.areaRange = areaRange;
            return this;
        }

        public Options maxAttempts(Long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
            this.useImageIfNoBoundingBoxes = useImageIfNoBoundingBoxes;
            return this;
        }

        private Options() {
        }
    }
}

