/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MaxPoolV2<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> MaxPoolV2<T> create(Scope scope, Operand<T> input, Operand<Integer> ksize, Operand<Integer> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("MaxPoolV2", scope.makeOpName("MaxPoolV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(ksize.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new MaxPoolV2<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private MaxPoolV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String dataFormat;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        private Options() {
        }
    }
}

