/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeNearestNeighbor<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> resizedImages;

    public static <T extends Number> ResizeNearestNeighbor<T> create(Scope scope, Operand<T> images, Operand<Integer> size, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("ResizeNearestNeighbor", scope.makeOpName("ResizeNearestNeighbor"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners == null) continue;
                opBuilder.setAttr("align_corners", opts.alignCorners);
            }
        }
        return new ResizeNearestNeighbor<T>(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public Output<T> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<T> asOutput() {
        return this.resizedImages;
    }

    private ResizeNearestNeighbor(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

