/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LRNGrad<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> LRNGrad<T> create(Scope scope, Operand<T> inputGrads, Operand<T> inputImage, Operand<T> outputImage, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("LRNGrad", scope.makeOpName("LRNGrad"));
        opBuilder.addInput(inputGrads.asOutput());
        opBuilder.addInput(inputImage.asOutput());
        opBuilder.addInput(outputImage.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.depthRadius != null) {
                    opBuilder.setAttr("depth_radius", opts.depthRadius);
                }
                if (opts.bias != null) {
                    opBuilder.setAttr("bias", opts.bias.floatValue());
                }
                if (opts.alpha != null) {
                    opBuilder.setAttr("alpha", opts.alpha.floatValue());
                }
                if (opts.beta == null) continue;
                opBuilder.setAttr("beta", opts.beta.floatValue());
            }
        }
        return new LRNGrad<T>(opBuilder.build());
    }

    public static Options depthRadius(Long depthRadius) {
        return new Options().depthRadius(depthRadius);
    }

    public static Options bias(Float bias) {
        return new Options().bias(bias);
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public static Options beta(Float beta) {
        return new Options().beta(beta);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private LRNGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long depthRadius;
        private Float bias;
        private Float alpha;
        private Float beta;

        public Options depthRadius(Long depthRadius) {
            this.depthRadius = depthRadius;
            return this;
        }

        public Options bias(Float bias) {
            this.bias = bias;
            return this;
        }

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Options beta(Float beta) {
            this.beta = beta;
            return this;
        }

        private Options() {
        }
    }
}

