/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Assign<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> outputRef;

    public static <T> Assign<T> create(Scope scope, Operand<T> ref, Operand<T> value, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Assign", scope.makeOpName("Assign"));
        opBuilder.addInput(ref.asOutput());
        opBuilder.addInput(value.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateShape != null) {
                    opBuilder.setAttr("validate_shape", opts.validateShape);
                }
                if (opts.useLocking == null) continue;
                opBuilder.setAttr("use_locking", opts.useLocking);
            }
        }
        return new Assign<T>(opBuilder.build());
    }

    public static Options validateShape(Boolean validateShape) {
        return new Options().validateShape(validateShape);
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public Output<T> outputRef() {
        return this.outputRef;
    }

    @Override
    public Output<T> asOutput() {
        return this.outputRef;
    }

    private Assign(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputRef = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateShape;
        private Boolean useLocking;

        public Options validateShape(Boolean validateShape) {
            this.validateShape = validateShape;
            return this;
        }

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        private Options() {
        }
    }
}

