/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseApplyAdagrad<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> out;

    public static <T, U extends Number> SparseApplyAdagrad<T> create(Scope scope, Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SparseApplyAdagrad", scope.makeOpName("SparseApplyAdagrad"));
        opBuilder.addInput(var.asOutput());
        opBuilder.addInput(accum.asOutput());
        opBuilder.addInput(lr.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(indices.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.useLocking != null) {
                    opBuilder.setAttr("use_locking", opts.useLocking);
                }
                if (opts.updateSlots == null) continue;
                opBuilder.setAttr("update_slots", opts.updateSlots);
            }
        }
        return new SparseApplyAdagrad<T>(opBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options updateSlots(Boolean updateSlots) {
        return new Options().updateSlots(updateSlots);
    }

    public Output<T> out() {
        return this.out;
    }

    @Override
    public Output<T> asOutput() {
        return this.out;
    }

    private SparseApplyAdagrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean updateSlots;

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options updateSlots(Boolean updateSlots) {
            this.updateSlots = updateSlots;
            return this;
        }

        private Options() {
        }
    }
}

