/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class NonMaxSuppression
extends PrimitiveOp
implements Operand<Integer> {
    private Output<Integer> selectedIndices;

    public static NonMaxSuppression create(Scope scope, Operand<Float> boxes, Operand<Float> scores, Operand<Integer> maxOutputSize, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("NonMaxSuppression", scope.makeOpName("NonMaxSuppression"));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSize.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.iouThreshold == null) continue;
                opBuilder.setAttr("iou_threshold", opts.iouThreshold.floatValue());
            }
        }
        return new NonMaxSuppression(opBuilder.build());
    }

    public static Options iouThreshold(Float iouThreshold) {
        return new Options().iouThreshold(iouThreshold);
    }

    public Output<Integer> selectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public Output<Integer> asOutput() {
        return this.selectedIndices;
    }

    private NonMaxSuppression(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.selectedIndices = operation.output(outputIdx++);
    }

    public static class Options {
        private Float iouThreshold;

        public Options iouThreshold(Float iouThreshold) {
            this.iouThreshold = iouThreshold;
            return this;
        }

        private Options() {
        }
    }
}

