/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Finds unique elements in a 1-D tensor.
 * <p>
 * This operation returns a tensor `y` containing all of the unique elements of `x`
 * sorted in the same order that they occur in `x`. This operation also returns a
 * tensor `idx` the same size as `x` that contains the index of each value of `x`
 * in the unique output `y`. Finally, it returns a third tensor `count` that
 * contains the count of each element of `y` in `x`. In other words:
 * <p>
 * `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
 * <p>
 * For example:
 * <pre>{@code
 * # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
 * y, idx, count = unique_with_counts(x)
 * y ==> [1, 2, 4, 7, 8]
 * idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
 * count ==> [2, 1, 3, 1, 2]
 * }</pre>
 * 
 * 
 * @param <T> data type for {@code y()} output
 * @param <U> data type for {@code idx()} output
 */
@Operator
public final class UniqueWithCounts<T, U extends Number> extends PrimitiveOp {
  
  /**
   * Factory method to create a class to wrap a new UniqueWithCounts operation to the graph.
   * 
   * @param scope current graph scope
   * @param x 1-D.
   * @param outIdx 
   * @return a new instance of UniqueWithCounts
   */
  public static <T, U extends Number> UniqueWithCounts<T, U> create(Scope scope, Operand<T> x, Class<U> outIdx) {
    OperationBuilder opBuilder = scope.graph().opBuilder("UniqueWithCounts", scope.makeOpName("UniqueWithCounts"));
    opBuilder.addInput(x.asOutput());
    opBuilder.setAttr("out_idx", DataType.fromClass(outIdx));
    return new UniqueWithCounts<T, U>(opBuilder.build());
  }
  
  /**
   * 1-D.
   */
  public Output<T> y() {
    return y;
  }
  
  /**
   * 1-D.
   */
  public Output<U> idx() {
    return idx;
  }
  
  /**
   * 1-D.
   */
  public Output<U> count() {
    return count;
  }
  
  private Output<T> y;
  private Output<U> idx;
  private Output<U> count;
  
  private UniqueWithCounts(Operation operation) {
    super(operation);
    int outputIdx = 0;
    y = operation.output(outputIdx++);
    idx = operation.output(outputIdx++);
    count = operation.output(outputIdx++);
  }
}
