/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Outputs a `Summary` protocol buffer with a tensor.
 * <p>
 * This op is being phased out in favor of TensorSummaryV2, which lets callers pass
 * a tag as well as a serialized SummaryMetadata proto string that contains
 * plugin-specific data. We will keep this op to maintain backwards compatibility.
 */
@Operator
public final class TensorSummary extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.TensorSummary}
   */
  public static class Options {
    
    /**
     * @param description A json-encoded SummaryDescription proto.
     */
    public Options description(String description) {
      this.description = description;
      return this;
    }
    
    /**
     * @param labels An unused list of strings.
     */
    public Options labels(List<String> labels) {
      this.labels = labels;
      return this;
    }
    
    /**
     * @param displayName An unused string.
     */
    public Options displayName(String displayName) {
      this.displayName = displayName;
      return this;
    }
    
    private String description;
    private List<String> labels;
    private String displayName;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new TensorSummary operation to the graph.
   * 
   * @param scope current graph scope
   * @param tensor A tensor to serialize.
   * @param options carries optional attributes values
   * @return a new instance of TensorSummary
   */
  public static <T> TensorSummary create(Scope scope, Operand<T> tensor, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("TensorSummary", scope.makeOpName("TensorSummary"));
    opBuilder.addInput(tensor.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.description != null) {
          opBuilder.setAttr("description", opts.description);
        }
        if (opts.labels != null) {
          String[] labelsArray = new String[opts.labels.size()];
          for (int i = 0; i < labelsArray.length; ++i) {
            labelsArray[i] = opts.labels.get(i);
          }
          opBuilder.setAttr("labels", labelsArray);
        }
        if (opts.displayName != null) {
          opBuilder.setAttr("display_name", opts.displayName);
        }
      }
    }
    return new TensorSummary(opBuilder.build());
  }
  
  /**
   * @param description A json-encoded SummaryDescription proto.
   */
  public static Options description(String description) {
    return new Options().description(description);
  }
  
  /**
   * @param labels An unused list of strings.
   */
  public static Options labels(List<String> labels) {
    return new Options().labels(labels);
  }
  
  /**
   * @param displayName An unused string.
   */
  public static Options displayName(String displayName) {
    return new Options().displayName(displayName);
  }
  
  /**
   */
  public Output<String> summary() {
    return summary;
  }
  
  @Override
  public Output<String> asOutput() {
    return summary;
  }
  
  private Output<String> summary;
  
  private TensorSummary(Operation operation) {
    super(operation);
    int outputIdx = 0;
    summary = operation.output(outputIdx++);
  }
}
