/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Applies L1 regularization shrink step on the parameters.
 */
@Operator
public final class SdcaShrinkL1 extends PrimitiveOp {
  
  /**
   * Factory method to create a class to wrap a new SdcaShrinkL1 operation to the graph.
   * 
   * @param scope current graph scope
   * @param weights a list of vectors where each value is the weight associated with a
   * feature group.
   * @param l1 Symmetric l1 regularization strength.
   * @param l2 Symmetric l2 regularization strength. Should be a positive float.
   * @return a new instance of SdcaShrinkL1
   */
  public static SdcaShrinkL1 create(Scope scope, Iterable<Operand<Float>> weights, Float l1, Float l2) {
    OperationBuilder opBuilder = scope.graph().opBuilder("SdcaShrinkL1", scope.makeOpName("SdcaShrinkL1"));
    opBuilder.addInputList(Operands.asOutputs(weights));
    opBuilder.setAttr("l1", l1);
    opBuilder.setAttr("l2", l2);
    return new SdcaShrinkL1(opBuilder.build());
  }
  
  
  private SdcaShrinkL1(Operation operation) {
    super(operation);
  }
}
