/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Compute the polygamma function \\(\psi^{(n)}(x)\\).
 * <p>
 * The polygamma function is defined as:
 * <p>
 * \\(\psi^{(n)}(x) = \frac{d^n}{dx^n} \psi(x)\\)
 * <p>
 * where \\(\psi(x)\\) is the digamma function.
 * 
 * @param <T> data type for {@code z()} output
 */
@Operator
public final class Polygamma<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new Polygamma operation to the graph.
   * 
   * @param scope current graph scope
   * @param a 
   * @param x 
   * @return a new instance of Polygamma
   */
  public static <T extends Number> Polygamma<T> create(Scope scope, Operand<T> a, Operand<T> x) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Polygamma", scope.makeOpName("Polygamma"));
    opBuilder.addInput(a.asOutput());
    opBuilder.addInput(x.asOutput());
    return new Polygamma<T>(opBuilder.build());
  }
  
  /**
   */
  public Output<T> z() {
    return z;
  }
  
  @Override
  public Output<T> asOutput() {
    return z;
  }
  
  private Output<T> z;
  
  private Polygamma(Operation operation) {
    super(operation);
    int outputIdx = 0;
    z = operation.output(outputIdx++);
  }
}
