/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

/**
 * Creates a dataset that batches and pads `batch_size` elements from the input.
 */
public final class PaddedBatchDatasetV2 extends PrimitiveOp implements Operand<Object> {
  
  /**
   * Factory method to create a class to wrap a new PaddedBatchDatasetV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param inputDataset 
   * @param batchSize A scalar representing the number of elements to accumulate in a
   * batch.
   * @param paddedShapes A list of int64 tensors representing the desired padded shapes
   * of the corresponding output components. These shapes may be partially
   * specified, using `-1` to indicate that a particular dimension should be
   * padded to the maximum size of all batch elements.
   * @param paddingValues A list of scalars containing the padding value to use for
   * each of the outputs.
   * @param dropRemainder A scalar representing whether the last batch should be dropped in case its size
   * is smaller than desired.
   * @param outputShapes 
   * @return a new instance of PaddedBatchDatasetV2
   */
  public static PaddedBatchDatasetV2 create(Scope scope, Operand<?> inputDataset, Operand<Long> batchSize, Iterable<Operand<Long>> paddedShapes, Iterable<Operand<?>> paddingValues, Operand<Boolean> dropRemainder, List<Shape> outputShapes) {
    OperationBuilder opBuilder = scope.graph().opBuilder("PaddedBatchDatasetV2", scope.makeOpName("PaddedBatchDatasetV2"));
    opBuilder.addInput(inputDataset.asOutput());
    opBuilder.addInput(batchSize.asOutput());
    opBuilder.addInputList(Operands.asOutputs(paddedShapes));
    opBuilder.addInputList(Operands.asOutputs(paddingValues));
    opBuilder.addInput(dropRemainder.asOutput());
    Shape[] outputShapesArray = new Shape[outputShapes.size()];
    for (int i = 0; i < outputShapesArray.length; ++i) {
      outputShapesArray[i] = outputShapes.get(i);
    }
    opBuilder.setAttr("output_shapes", outputShapesArray);
    return new PaddedBatchDatasetV2(opBuilder.build());
  }
  
  /**
   */
  public Output<?> handle() {
    return handle;
  }
  
  @Override
  @SuppressWarnings("unchecked")
  public Output<Object> asOutput() {
    return (Output<Object>) handle;
  }
  
  private Output<?> handle;
  
  private PaddedBatchDatasetV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    handle = operation.output(outputIdx++);
  }
}
