/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Pads a tensor.
 * <p>
 * This operation pads `input` according to the `paddings` and `constant_values`
 * you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
 * the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
 * how many padding values to add before the contents of `input` in that dimension,
 * and `paddings[D, 1]` indicates how many padding values to add after the contents
 * of `input` in that dimension. `constant_values` is a scalar tensor of the same
 * type as `input` that indicates the value to use for padding `input`.
 * <p>
 * The padded size of each dimension D of the output is:
 * <p>
 * `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
 * <p>
 * For example:
 * <pre>{@code
 * # 't' is [[1, 1], [2, 2]]
 * # 'paddings' is [[1, 1], [2, 2]]
 * # 'constant_values' is 0
 * # rank of 't' is 2
 * pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
 *                       [0, 0, 1, 1, 0, 0]
 *                       [0, 0, 2, 2, 0, 0]
 *                       [0, 0, 0, 0, 0, 0]]
 * }</pre>
 * 
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class PadV2<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new PadV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 
   * @param paddings 
   * @param constantValues 
   * @return a new instance of PadV2
   */
  public static <T, U extends Number> PadV2<T> create(Scope scope, Operand<T> input, Operand<U> paddings, Operand<T> constantValues) {
    OperationBuilder opBuilder = scope.graph().opBuilder("PadV2", scope.makeOpName("PadV2"));
    opBuilder.addInput(input.asOutput());
    opBuilder.addInput(paddings.asOutput());
    opBuilder.addInput(constantValues.asOutput());
    return new PadV2<T>(opBuilder.build());
  }
  
  /**
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private PadV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
